/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.actions;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.PrivilegesEvaluationResult;
import com.floragunn.searchguard.authz.SystemIndexAccess;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchsupport.action.IndicesOptionsSupport;
import com.floragunn.searchsupport.meta.Meta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.AliasesRequest;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.resolve.ResolveIndexAction;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.downsample.DownsampleAction;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchContextId;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.rest.root.MainRequest;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotUtils;

public class ActionRequestIntrospector {
    private static final IndicesOptions EXACT = IndicesOptionsSupport.EXACT;
    private static final Set<String> NAME_BASED_SHORTCUTS_FOR_CLUSTER_ACTIONS = ImmutableSet.of((Object)"indices:data/read/msearch/template", (Object[])new String[]{"indices:data/read/search/template", "indices:data/read/sql/translate", "indices:data/read/sql", "indices:data/read/sql/close_cursor", "cluster:admin/scripts/painless/execute", "indices:admin/template/get", "cluster:admin/component_template/get", "indices:admin/index_template/get", "indices:admin/index_template/simulate_index", "indices:admin/index_template/simulate", "indices:data/read/close_point_in_time"});
    private static final Logger log = LogManager.getLogger(ActionRequestIntrospector.class);
    private final Supplier<Meta> metaDataSupplier;
    private final Supplier<SystemIndexAccess> systemIndexAccessSupplier;
    private final BooleanSupplier isLocalNodeElectedMaster;
    private final Function<RestoreSnapshotRequest, SnapshotInfo> getSnapshotInfoFunction;
    private final ActionRequestInfo CLUSTER_REQUEST = new ActionRequestInfo(false, false, null);

    public ActionRequestIntrospector(Supplier<Meta> metaDataSupplier, Supplier<SystemIndexAccess> systemIndexAccessSupplier, BooleanSupplier isLocalNodeElectedMaster, Function<RestoreSnapshotRequest, SnapshotInfo> getSnapshotInfoFunction) {
        this.metaDataSupplier = metaDataSupplier;
        this.isLocalNodeElectedMaster = isLocalNodeElectedMaster;
        this.getSnapshotInfoFunction = getSnapshotInfoFunction;
        this.systemIndexAccessSupplier = systemIndexAccessSupplier;
    }

    public ActionRequestInfo getActionRequestInfo(Action action, Object request) {
        SearchRequest searchRequest;
        if (NAME_BASED_SHORTCUTS_FOR_CLUSTER_ACTIONS.contains(action.name())) {
            return this.CLUSTER_REQUEST;
        }
        if (request instanceof SearchRequest && (searchRequest = (SearchRequest)request).pointInTimeBuilder() != null) {
            BytesReference pointInTimeId = searchRequest.pointInTimeBuilder().getEncodedId();
            Object[] indices = SearchContextId.decodeIndices((BytesReference)pointInTimeId);
            return new ActionRequestInfo((List<String>)(indices == null ? ImmutableList.empty() : ImmutableList.ofArray((Object[])indices)), EXACT, IndicesRequestInfo.Scope.ANY);
        }
        if (request instanceof SingleShardRequest) {
            SingleShardRequest singleShardRequest = (SingleShardRequest)request;
            if (singleShardRequest.index() != null) {
                return new ActionRequestInfo(singleShardRequest.index(), SingleShardRequest.INDICES_OPTIONS, IndicesRequestInfo.Scope.ANY);
            }
            return new ActionRequestInfo("*", IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN, IndicesRequestInfo.Scope.ANY);
        }
        if (request instanceof IndicesRequest) {
            if (action.scope() == Action.Scope.DATA_STREAM) {
                return new ActionRequestInfo((IndicesRequest)request, IndicesRequestInfo.Scope.DATA_STREAM);
            }
            if (request instanceof AliasesRequest) {
                AliasesRequest aliasesRequest = (AliasesRequest)request;
                IndicesRequest indicesRequest = (IndicesRequest)request;
                return new ActionRequestInfo(indicesRequest.indices(), indicesRequest.indicesOptions(), IndicesRequestInfo.Scope.INDICES_DATA_STREAMS).additional(Action.AdditionalDimension.ALIASES, aliasesRequest.aliases(), aliasesRequest.expandAliasesWildcards() ? IndicesOptions.lenientExpandHidden() : EXACT, IndicesRequestInfo.Scope.ALIAS);
            }
            if (request instanceof IndicesAliasesRequest) {
                IndicesAliasesRequest indicesAliasesRequest = (IndicesAliasesRequest)request;
                ActionRequestInfo result = new ActionRequestInfo((ImmutableSet<IndicesRequestInfo>)ImmutableSet.empty());
                for (IndicesAliasesRequest.AliasActions aliasAction : indicesAliasesRequest.getAliasActions()) {
                    switch (aliasAction.actionType()) {
                        case ADD: {
                            result = result.with((IndicesRequest)aliasAction, IndicesRequestInfo.Scope.INDICES_DATA_STREAMS).additional(Action.AdditionalDimension.ALIASES, aliasAction.aliases(), EXACT, IndicesRequestInfo.Scope.ALIAS);
                            break;
                        }
                        case REMOVE: {
                            IndicesRequestInfo aliasesRequestInfo = new IndicesRequestInfo(Action.AdditionalDimension.ALIASES, (List<String>)ImmutableList.ofArray((Object[])aliasAction.aliases()), aliasAction.expandAliasesWildcards() ? IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN : EXACT, IndicesRequestInfo.Scope.ALIAS, this.systemIndexAccessSupplier.get(), this.metaDataSupplier.get());
                            ImmutableSet<Meta.Alias> aliases = aliasesRequestInfo.resolveIndices().getLocal().getAliases();
                            IndicesRequestInfo indicesRequestInfo = new IndicesRequestInfo(null, (IndicesRequest)aliasAction, IndicesRequestInfo.Scope.INDICES_DATA_STREAMS, this.systemIndexAccessSupplier.get(), this.metaDataSupplier.get());
                            ImmutableSet<Meta.IndexLikeObject> indices = indicesRequestInfo.resolveIndices().getLocal().getUnion();
                            ImmutableSet indicesThatAreMembersOfSpecifiedAliases = indices.matching(i -> i.parentAliases().containsAny((Collection)aliases));
                            result = result.with((Collection<String>)indicesThatAreMembersOfSpecifiedAliases.map(Meta.IndexLikeObject::name), EXACT, IndicesRequestInfo.Scope.INDICES_DATA_STREAMS).additional(aliasesRequestInfo);
                            break;
                        }
                        case REMOVE_INDEX: {
                            result = result.additional(Action.AdditionalDimension.DELETE_INDEX, (IndicesRequest)aliasAction, IndicesRequestInfo.Scope.INDICES_DATA_STREAMS);
                        }
                    }
                }
                return result;
            }
            if (request instanceof CreateIndexRequest) {
                CreateIndexRequest createIndexRequest = (CreateIndexRequest)request;
                if (createIndexRequest.aliases() == null || createIndexRequest.aliases().isEmpty()) {
                    return new ActionRequestInfo((IndicesRequest)request, IndicesRequestInfo.Scope.ANY);
                }
                return new ActionRequestInfo((IndicesRequest)request, IndicesRequestInfo.Scope.ANY).additional(Action.AdditionalDimension.MANAGE_ALIASES, (ImmutableList<String>)ImmutableList.of((Collection)createIndexRequest.aliases()).map(a -> a.name()), EXACT, IndicesRequestInfo.Scope.ALIAS);
            }
            if (request instanceof PutMappingRequest) {
                PutMappingRequest putMappingRequest = (PutMappingRequest)request;
                if (putMappingRequest.getConcreteIndex() != null) {
                    return new ActionRequestInfo(putMappingRequest.getConcreteIndex().getName(), EXACT, IndicesRequestInfo.Scope.ANY);
                }
                return new ActionRequestInfo((IndicesRequest)putMappingRequest, IndicesRequestInfo.Scope.ANY);
            }
            if (request instanceof ResizeRequest) {
                ResizeRequest resizeRequest = (ResizeRequest)request;
                return new ActionRequestInfo(resizeRequest.getSourceIndex(), EXACT, IndicesRequestInfo.Scope.ANY).additional(Action.AdditionalDimension.RESIZE_TARGET, (IndicesRequest)((ResizeRequest)request).getTargetIndexRequest(), IndicesRequestInfo.Scope.ANY);
            }
            if (request instanceof DownsampleAction.Request) {
                DownsampleAction.Request downsampleRequest = (DownsampleAction.Request)request;
                return new ActionRequestInfo(downsampleRequest.getSourceIndex(), downsampleRequest.indicesOptions(), IndicesRequestInfo.Scope.ANY).additional(Action.AdditionalDimension.DOWNSAMPLE_TARGET, (ImmutableList<String>)ImmutableList.of((Object)downsampleRequest.getTargetIndex()), EXACT, IndicesRequestInfo.Scope.ANY);
            }
            if (request instanceof ResolveIndexAction.Request) {
                return new ActionRequestInfo((IndicesRequest)request, IndicesRequestInfo.Scope.ANY_DISTINCT);
            }
            return new ActionRequestInfo((IndicesRequest)request, IndicesRequestInfo.Scope.ANY);
        }
        if (request instanceof CompositeIndicesRequest) {
            if (request instanceof BulkRequest) {
                return new ActionRequestInfo(((BulkRequest)request).requests(), IndicesRequestInfo.Scope.ANY);
            }
            if (request instanceof MultiGetRequest) {
                return new ActionRequestInfo(((MultiGetRequest)request).getItems(), IndicesRequestInfo.Scope.ANY);
            }
            if (request instanceof MultiSearchRequest) {
                return new ActionRequestInfo(((MultiSearchRequest)request).requests(), IndicesRequestInfo.Scope.ANY);
            }
            if (request instanceof MultiTermVectorsRequest) {
                return new ActionRequestInfo(((MultiTermVectorsRequest)request).getRequests(), IndicesRequestInfo.Scope.ANY);
            }
            if (request instanceof ReindexRequest) {
                return this.CLUSTER_REQUEST;
            }
            log.warn("Unknown action request: {} ", (Object)request.getClass().getName());
            return this.unknownActionRequest();
        }
        if (request instanceof RestoreSnapshotRequest) {
            if (!this.isLocalNodeElectedMaster.getAsBoolean()) {
                return this.unknownActionRequest();
            }
            RestoreSnapshotRequest restoreRequest = (RestoreSnapshotRequest)request;
            SnapshotInfo snapshotInfo = this.getSnapshotInfoFunction.apply(restoreRequest);
            if (snapshotInfo == null) {
                log.warn("snapshot repository '" + restoreRequest.repository() + "', snapshot '" + restoreRequest.snapshot() + "' not found");
                return this.unknownActionRequest();
            }
            List requestedResolvedIndices = SnapshotUtils.filterIndices((List)snapshotInfo.indices(), (String[])restoreRequest.indices(), (IndicesOptions)restoreRequest.indicesOptions());
            List<String> renamedTargetIndices = this.renamedIndices(restoreRequest, requestedResolvedIndices);
            if (log.isDebugEnabled()) {
                log.debug("snapshot {} contains {}", (Object)snapshotInfo.snapshotId().getName(), renamedTargetIndices);
            }
            return new ActionRequestInfo(renamedTargetIndices, EXACT, IndicesRequestInfo.Scope.ANY);
        }
        if (request instanceof BaseNodesRequest) {
            return this.CLUSTER_REQUEST;
        }
        if (request instanceof MainRequest) {
            return this.CLUSTER_REQUEST;
        }
        if (request instanceof ClearScrollRequest) {
            return this.CLUSTER_REQUEST;
        }
        if (request instanceof SearchScrollRequest) {
            return this.CLUSTER_REQUEST;
        }
        if (action.isIndexLikePrivilege()) {
            log.warn("Unknown action request: {}", (Object)request.getClass().getName());
            return this.unknownActionRequest();
        }
        log.debug("Unknown action request: {}", (Object)request.getClass().getName());
        return this.CLUSTER_REQUEST;
    }

    public boolean isReduceIndicesAvailable(Action action, Object request) {
        return request instanceof AnalyzeAction.Request || request instanceof IndicesRequest.Replaceable;
    }

    public PrivilegesEvaluationResult reduceIndices(Action action, Object request, ImmutableSet<String> keepIndices, ImmutableMap<Action.AdditionalDimension, ImmutableSet<String>> additionalKeepIndices, ActionRequestInfo actionRequestInfo) throws PrivilegesEvaluationException {
        if (log.isTraceEnabled()) {
            log.trace("Reducing indices of {} to {}", request, keepIndices);
        }
        if (request instanceof AnalyzeAction.Request) {
            AnalyzeAction.Request analyzeRequest = (AnalyzeAction.Request)request;
            if (analyzeRequest.index() == null) {
                return PrivilegesEvaluationResult.OK;
            }
            if (keepIndices.contains((Object)analyzeRequest.index())) {
                return PrivilegesEvaluationResult.OK;
            }
            return PrivilegesEvaluationResult.INSUFFICIENT;
        }
        if (request instanceof IndicesRequest.Replaceable) {
            IndicesRequest.Replaceable replaceableIndicesRequest = (IndicesRequest.Replaceable)request;
            actionRequestInfo = this.ensureActionRequestInfo(action, (IndicesRequest)replaceableIndicesRequest, actionRequestInfo);
            if (request instanceof AliasesRequest) {
                ImmutableSet keepAliases;
                AliasesRequest aliasesRequest = (AliasesRequest)request;
                if (keepIndices != null) {
                    ImmutableSet newIndices = ImmutableSet.of(keepIndices).with(actionRequestInfo.getResolvedIndices().getRemoteIndices());
                    if (!keepIndices.isEmpty()) {
                        aliasesRequest.indices(this.toArray((ImmutableSet<String>)newIndices));
                    } else {
                        return PrivilegesEvaluationResult.EMPTY;
                    }
                }
                if ((keepAliases = (ImmutableSet)additionalKeepIndices.get((Object)Action.AdditionalDimension.ALIASES)) != null) {
                    if (!keepAliases.isEmpty()) {
                        aliasesRequest.replaceAliases(this.toArray((ImmutableSet<String>)keepAliases));
                    } else {
                        return PrivilegesEvaluationResult.EMPTY;
                    }
                }
                this.validateIndexReduction(action, replaceableIndicesRequest, (Set<String>)keepIndices);
                return PrivilegesEvaluationResult.OK;
            }
            ResolvedIndices resolvedIndices = actionRequestInfo.getResolvedIndices();
            ImmutableSet actualIndices = resolvedIndices.getLocal().getUnion().map(Meta.IndexLikeObject::name);
            if (keepIndices.containsAll((Collection)actualIndices)) {
                return PrivilegesEvaluationResult.OK;
            }
            ImmutableSet newIndices = ImmutableSet.of(keepIndices).with(resolvedIndices.getRemoteIndices());
            if (log.isTraceEnabled()) {
                log.trace("reduceIndicesForIgnoreUnavailable: keep: {}; actual: {}; newIndices: {}; remote: {}", keepIndices, (Object)actualIndices, (Object)newIndices, resolvedIndices.getRemoteIndices());
            }
            if (newIndices.size() > 0) {
                replaceableIndicesRequest.indices(this.toArray((ImmutableSet<String>)newIndices));
                this.validateIndexReduction(action, replaceableIndicesRequest, (Set<String>)keepIndices);
                return PrivilegesEvaluationResult.OK;
            }
            return PrivilegesEvaluationResult.EMPTY;
        }
        log.debug("Cannot reduce the indices of {} because the request does not implement a suitable interface", request);
        return PrivilegesEvaluationResult.INSUFFICIENT;
    }

    private void validateIndexReduction(Action action, Object request, Set<String> keepIndices) throws PrivilegesEvaluationException {
        ActionRequestInfo newInfo = this.getActionRequestInfo(action, request);
        if (log.isDebugEnabled()) {
            log.debug("Reduced request to:\n{}\n{}", request, (Object)newInfo);
        }
        if (!keepIndices.containsAll((Collection<?>)newInfo.getMainResolvedIndices().getLocal().getUnion().map(Meta.IndexLikeObject::name))) {
            throw new PrivilegesEvaluationException("Indices were not properly reduced: " + request + "; new resolved:" + newInfo.getMainResolvedIndices() + "; keep: " + keepIndices);
        }
    }

    public boolean forceEmptyResult(Action action, Object request) throws PrivilegesEvaluationException {
        if (request instanceof IndicesRequest.Replaceable) {
            IndicesRequest.Replaceable replaceableIndicesRequest = (IndicesRequest.Replaceable)request;
            if (replaceableIndicesRequest.indicesOptions().expandWildcardsOpen() || replaceableIndicesRequest.indicesOptions().expandWildcardsClosed()) {
                replaceableIndicesRequest.indices(new String[]{".force_no_index*", "-*"});
            } else {
                replaceableIndicesRequest.indices(new String[0]);
            }
            if (request instanceof GetAliasesRequest) {
                ((GetAliasesRequest)request).aliases(new String[]{".force_no_alias*", "-*"});
            } else if (request instanceof AliasesRequest) {
                ((AliasesRequest)request).replaceAliases(new String[0]);
            }
            this.validateIndexReduction(action, replaceableIndicesRequest, Collections.emptySet());
            return true;
        }
        return false;
    }

    public boolean replaceIndices(Action action, Object request, Function<ResolvedIndices, List<String>> replacementFunction, ActionRequestInfo actionRequestInfo) {
        if (request instanceof IndicesRequest) {
            if (request instanceof IndicesRequest.Replaceable) {
                IndicesRequest.Replaceable replaceableIndicesRequest = (IndicesRequest.Replaceable)request;
                String[] indices = this.applyReplacementFunction(action, (IndicesRequest)replaceableIndicesRequest, replacementFunction, actionRequestInfo);
                if (indices.length > 0) {
                    replaceableIndicesRequest.indices(indices);
                    return true;
                }
                return false;
            }
            if (request instanceof SingleShardRequest) {
                SingleShardRequest singleShardRequest = (SingleShardRequest)request;
                String[] indices = this.applyReplacementFunction(action, (IndicesRequest)singleShardRequest, replacementFunction, actionRequestInfo);
                if (indices.length == 1) {
                    singleShardRequest.index(indices[0]);
                    return true;
                }
                return false;
            }
        } else if (request instanceof CompositeIndicesRequest) {
            if (request instanceof MultiSearchRequest) {
                for (SearchRequest searchRequest : ((MultiSearchRequest)request).requests()) {
                    if (this.replaceIndices(action, searchRequest, replacementFunction, actionRequestInfo)) continue;
                    return false;
                }
                return true;
            }
            if (request instanceof MultiTermVectorsRequest) {
                for (TermVectorsRequest termVectorsRequest : ((MultiTermVectorsRequest)request).getRequests()) {
                    if (this.replaceIndices(action, termVectorsRequest, replacementFunction, actionRequestInfo)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private ActionRequestInfo ensureActionRequestInfo(Action action, IndicesRequest indicesRequest, ActionRequestInfo actionRequestInfo) {
        if (actionRequestInfo != null && actionRequestInfo.isFor(indicesRequest)) {
            return actionRequestInfo;
        }
        return new ActionRequestInfo(indicesRequest, action.scope() == Action.Scope.DATA_STREAM ? IndicesRequestInfo.Scope.DATA_STREAM : IndicesRequestInfo.Scope.ANY);
    }

    private String[] applyReplacementFunction(Action action, IndicesRequest indicesRequest, Function<ResolvedIndices, List<String>> replacementFunction, ActionRequestInfo actionRequestInfo) {
        actionRequestInfo = this.ensureActionRequestInfo(action, indicesRequest, actionRequestInfo);
        ArrayList<String> replacedLocalIndices = new ArrayList<String>((Collection)replacementFunction.apply(actionRequestInfo.getResolvedIndices()));
        replacedLocalIndices.addAll((Collection<String>)actionRequestInfo.getResolvedIndices().getRemoteIndices());
        return replacedLocalIndices.toArray(new String[replacedLocalIndices.size()]);
    }

    private List<String> renamedIndices(RestoreSnapshotRequest request, List<String> filteredIndices) {
        try {
            ArrayList<String> renamedIndices = new ArrayList<String>();
            Iterator<String> iterator = filteredIndices.iterator();
            while (iterator.hasNext()) {
                String index;
                String renamedIndex = index = iterator.next();
                if (request.renameReplacement() != null && request.renamePattern() != null) {
                    renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
                }
                renamedIndices.add(renamedIndex);
            }
            return renamedIndices;
        }
        catch (PatternSyntaxException e) {
            log.error("Unable to parse the regular expression denoted in 'rename_pattern'. Please correct the pattern and try again.", (Throwable)e);
            throw e;
        }
    }

    private String[] toArray(ImmutableSet<String> set) {
        return (String[])set.toArray((Object[])new String[set.size()]);
    }

    private ActionRequestInfo unknownActionRequest() {
        return new ActionRequestInfo(true, true, (ImmutableSet<IndicesRequestInfo>)ImmutableSet.of((Object)this.localAllIndicesRequestInfo()));
    }

    private ResolvedIndices localAll() {
        return new ResolvedIndices(true, ResolvedIndices.Local.EMPTY, (ImmutableSet<String>)ImmutableSet.empty(), (ImmutableSet<IndicesRequestInfo>)ImmutableSet.of((Object)this.localAllIndicesRequestInfo()));
    }

    private IndicesRequestInfo localAllIndicesRequestInfo() {
        return new IndicesRequestInfo((List<String>)ImmutableList.of((Object)"*"), IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED, IndicesRequestInfo.Scope.ANY, this.systemIndexAccessSupplier.get(), this.metaDataSupplier.get());
    }

    private ImmutableSet<IndicesRequestInfo> from(Collection<? extends IndicesRequest> indicesRequests, IndicesRequestInfo.Scope scope) {
        if (indicesRequests.isEmpty()) {
            return ImmutableSet.empty();
        }
        Meta indexMetadata = this.metaDataSupplier.get();
        SystemIndexAccess systemIndexAccess = this.systemIndexAccessSupplier.get();
        IndicesRequest first = null;
        IndicesRequestInfo firstInfo = null;
        ImmutableSet.Builder set = null;
        for (IndicesRequest indicesRequest : indicesRequests) {
            if (set != null) {
                set.add((Object)new IndicesRequestInfo(null, indicesRequest, scope, systemIndexAccess, indexMetadata));
                continue;
            }
            if (first == null) {
                first = indicesRequest;
                firstInfo = new IndicesRequestInfo(null, indicesRequest, scope, systemIndexAccess, indexMetadata);
                continue;
            }
            if (ActionRequestIntrospector.equals(indicesRequest, first)) continue;
            set = new ImmutableSet.Builder(indicesRequests.size());
            set.add((Object)firstInfo);
            set.add((Object)new IndicesRequestInfo(null, indicesRequest, scope, systemIndexAccess, indexMetadata));
        }
        if (set != null) {
            return set.build();
        }
        return ImmutableSet.of(firstInfo);
    }

    static boolean containsWildcard(Collection<String> indices) {
        return indices == null || indices.stream().anyMatch(i -> i != null && (i.contains("*") || i.equals("_all")));
    }

    static boolean containsWildcard(String index) {
        return index == null || index.contains("*") || index.equals("_all");
    }

    private static boolean equals(IndicesRequest a, IndicesRequest b) {
        return Arrays.equals(a.indices(), b.indices()) && Objects.equals(a.indicesOptions(), b.indicesOptions()) && (a instanceof IndicesRequest.Replaceable ? ((IndicesRequest.Replaceable)a).allowsRemoteIndices() : false) == (b instanceof IndicesRequest.Replaceable ? ((IndicesRequest.Replaceable)b).allowsRemoteIndices() : false) && a.includeDataStreams() == b.includeDataStreams();
    }

    public class ActionRequestInfo {
        private final boolean unknown;
        private final boolean indexRequest;
        private final ImmutableSet<IndicesRequestInfo> indices;
        private Object sourceRequest;
        private boolean resolvedIndicesInitialized = false;
        private ResolvedIndices mainResolvedIndices;
        private ResolvedIndices allResolvedIndices;
        private ImmutableMap<Action.AdditionalDimension, ResolvedIndices> additionalResolvedIndices;
        private Boolean containsWildcards;

        ActionRequestInfo(ImmutableSet<IndicesRequestInfo> indices) {
            this.unknown = false;
            this.indexRequest = true;
            this.indices = indices;
        }

        ActionRequestInfo(boolean unknown, boolean indexRequest, ImmutableSet<IndicesRequestInfo> indices) {
            this.unknown = unknown;
            this.indexRequest = indexRequest;
            this.indices = indices;
        }

        ActionRequestInfo(IndicesRequest indices, IndicesRequestInfo.Scope scope) {
            this((ImmutableSet<IndicesRequestInfo>)ImmutableSet.of((Object)new IndicesRequestInfo(null, indices, scope, this$0.systemIndexAccessSupplier.get(), this$0.metaDataSupplier.get())));
            this.sourceRequest = indices;
        }

        ActionRequestInfo(Collection<? extends IndicesRequest> indices, IndicesRequestInfo.Scope scope) {
            this(this$0.from(indices, scope));
        }

        ActionRequestInfo(String index, IndicesOptions indicesOptions, IndicesRequestInfo.Scope scope) {
            this((ImmutableSet<IndicesRequestInfo>)ImmutableSet.of((Object)new IndicesRequestInfo(null, index, indicesOptions, scope, this$0.systemIndexAccessSupplier.get(), this$0.metaDataSupplier.get())));
        }

        ActionRequestInfo(String[] indices, IndicesOptions indicesOptions, IndicesRequestInfo.Scope scope) {
            this((List<String>)ImmutableList.ofArray((Object[])indices), indicesOptions, scope);
        }

        ActionRequestInfo(List<String> index, IndicesOptions indicesOptions, IndicesRequestInfo.Scope scope) {
            this((ImmutableSet<IndicesRequestInfo>)ImmutableSet.of((Object)new IndicesRequestInfo(null, index, indicesOptions, scope, this$0.systemIndexAccessSupplier.get(), this$0.metaDataSupplier.get())));
        }

        ActionRequestInfo with(IndicesRequest indices, IndicesRequestInfo.Scope scope) {
            return new ActionRequestInfo(this.unknown, this.indexRequest, (ImmutableSet<IndicesRequestInfo>)this.indices.with((Object)new IndicesRequestInfo(null, indices, scope, ActionRequestIntrospector.this.systemIndexAccessSupplier.get(), ActionRequestIntrospector.this.metaDataSupplier.get())));
        }

        ActionRequestInfo with(String[] indices, IndicesOptions indicesOptions, IndicesRequestInfo.Scope scope) {
            return new ActionRequestInfo(this.unknown, this.indexRequest, (ImmutableSet<IndicesRequestInfo>)this.indices.with((Object)new IndicesRequestInfo(null, (List<String>)ImmutableList.ofArray((Object[])indices), indicesOptions, scope, ActionRequestIntrospector.this.systemIndexAccessSupplier.get(), ActionRequestIntrospector.this.metaDataSupplier.get())));
        }

        ActionRequestInfo with(Collection<String> indices, IndicesOptions indicesOptions, IndicesRequestInfo.Scope scope) {
            return new ActionRequestInfo(this.unknown, this.indexRequest, (ImmutableSet<IndicesRequestInfo>)this.indices.with((Object)new IndicesRequestInfo(null, (List<String>)ImmutableList.of(indices), indicesOptions, scope, ActionRequestIntrospector.this.systemIndexAccessSupplier.get(), ActionRequestIntrospector.this.metaDataSupplier.get())));
        }

        ActionRequestInfo additional(Action.AdditionalDimension role, IndicesRequest indices, IndicesRequestInfo.Scope scope) {
            return new ActionRequestInfo(this.unknown, this.indexRequest, (ImmutableSet<IndicesRequestInfo>)this.indices.with((Object)new IndicesRequestInfo(role, indices, scope, ActionRequestIntrospector.this.systemIndexAccessSupplier.get(), ActionRequestIntrospector.this.metaDataSupplier.get())));
        }

        ActionRequestInfo additional(Action.AdditionalDimension role, Collection<? extends IndicesRequest> requests, IndicesRequestInfo.Scope scope) {
            Meta meta = ActionRequestIntrospector.this.metaDataSupplier.get();
            SystemIndexAccess systemIndexAccess = ActionRequestIntrospector.this.systemIndexAccessSupplier.get();
            return new ActionRequestInfo(this.unknown, this.indexRequest, (ImmutableSet<IndicesRequestInfo>)this.indices.with((Collection)requests.stream().map(r -> new IndicesRequestInfo(role, (IndicesRequest)r, scope, systemIndexAccess, meta)).collect(Collectors.toList())));
        }

        ActionRequestInfo additional(Action.AdditionalDimension role, ImmutableList<String> indices, IndicesOptions indicesOptions, IndicesRequestInfo.Scope scope) {
            return new ActionRequestInfo(this.unknown, this.indexRequest, (ImmutableSet<IndicesRequestInfo>)this.indices.with((Object)new IndicesRequestInfo(role, (List<String>)indices, indicesOptions, scope, ActionRequestIntrospector.this.systemIndexAccessSupplier.get(), ActionRequestIntrospector.this.metaDataSupplier.get())));
        }

        ActionRequestInfo additional(Action.AdditionalDimension role, String[] indices, IndicesOptions indicesOptions, IndicesRequestInfo.Scope scope) {
            return this.additional(role, (ImmutableList<String>)ImmutableList.ofArray((Object[])indices), indicesOptions, scope);
        }

        ActionRequestInfo additional(IndicesRequestInfo indexRequestInfo) {
            return new ActionRequestInfo(this.unknown, this.indexRequest, (ImmutableSet<IndicesRequestInfo>)this.indices.with((Object)indexRequestInfo));
        }

        public boolean isUnknown() {
            return this.unknown;
        }

        public boolean isIndexRequest() {
            return this.indexRequest;
        }

        public boolean containsWildcards() {
            if (this.containsWildcards == null) {
                boolean result = this.indices != null ? this.indices.stream().anyMatch(i -> i.containsWildcards()) : false;
                this.containsWildcards = result;
                return result;
            }
            return this.containsWildcards;
        }

        public ResolvedIndices getResolvedIndices() {
            if (!this.resolvedIndicesInitialized) {
                this.initResolvedIndices();
                this.resolvedIndicesInitialized = true;
            }
            return this.allResolvedIndices;
        }

        public ResolvedIndices getMainResolvedIndices() {
            if (!this.resolvedIndicesInitialized) {
                this.initResolvedIndices();
                this.resolvedIndicesInitialized = true;
            }
            return this.mainResolvedIndices;
        }

        public ImmutableMap<Action.AdditionalDimension, ResolvedIndices> getAdditionalResolvedIndices() {
            if (!this.resolvedIndicesInitialized) {
                this.initResolvedIndices();
                this.resolvedIndicesInitialized = true;
            }
            return this.additionalResolvedIndices;
        }

        public boolean ignoreUnavailable() {
            if (this.indices == null || this.indices.size() == 0) {
                return false;
            }
            for (IndicesRequestInfo index : this.indices) {
                if (index.indicesOptions().ignoreUnavailable()) continue;
                return false;
            }
            return true;
        }

        private void initResolvedIndices() {
            if (this.unknown || !this.indexRequest) {
                this.mainResolvedIndices = this.allResolvedIndices = ActionRequestIntrospector.this.localAll();
                this.additionalResolvedIndices = ImmutableMap.empty();
                return;
            }
            int numberOfEntries = this.indices.size();
            if (numberOfEntries == 0) {
                this.mainResolvedIndices = this.allResolvedIndices = ActionRequestIntrospector.this.localAll();
                this.additionalResolvedIndices = ImmutableMap.empty();
            } else if (numberOfEntries == 1 && ((IndicesRequestInfo)this.indices.only()).role == null) {
                this.mainResolvedIndices = this.allResolvedIndices = ((IndicesRequestInfo)this.indices.only()).resolveIndices();
                this.additionalResolvedIndices = ImmutableMap.empty();
            } else {
                ResolvedIndices mainResolvedIndices = ResolvedIndices.EMPTY;
                ImmutableMap additionalResolvedIndicesMap = ImmutableMap.empty();
                for (IndicesRequestInfo info : this.indices) {
                    ResolvedIndices singleResolved = info.resolveIndices();
                    if (info.role == null) {
                        mainResolvedIndices = singleResolved.with(mainResolvedIndices);
                        continue;
                    }
                    additionalResolvedIndicesMap = additionalResolvedIndicesMap.withComputed((Object)info.role, additionalResolvedIndices -> singleResolved.with((ResolvedIndices)additionalResolvedIndices));
                }
                this.mainResolvedIndices = mainResolvedIndices;
                this.additionalResolvedIndices = additionalResolvedIndicesMap;
                this.allResolvedIndices = additionalResolvedIndicesMap.isEmpty() ? mainResolvedIndices : mainResolvedIndices.with((Collection<ResolvedIndices>)additionalResolvedIndicesMap.values());
            }
        }

        public boolean isFor(Object sourceRequest) {
            return this.sourceRequest == sourceRequest;
        }

        public String toString() {
            if (this.unknown) {
                return "UNKNOWN";
            }
            if (!this.indexRequest) {
                return "CLUSTER_REQUEST";
            }
            return "main: " + this.getMainResolvedIndices() + "; additional: " + this.getAdditionalResolvedIndices() + "; source: " + this.indices;
        }

        public ImmutableSet<IndicesRequestInfo> getUnresolved() {
            return this.indices;
        }
    }

    static class IndicesRequestInfo {
        private final ImmutableList<String> indices;
        private final String[] indicesArray;
        private final IndicesOptions indicesOptions;
        private final boolean allowsRemoteIndices;
        final boolean includeDataStreams;
        private final Action.AdditionalDimension role;
        final boolean expandWildcards;
        final boolean isAll;
        private final boolean containsWildcards;
        private final boolean writeRequest;
        final boolean createIndexRequest;
        final SystemIndexAccess systemIndexAccess;
        final Meta indexMetadata;
        private final ImmutableSet<String> remoteIndices;
        final ImmutableList<String> localIndices;
        final Scope scope;
        private final boolean negationOnlyEffectiveForIndices;

        IndicesRequestInfo(Action.AdditionalDimension role, IndicesRequest indicesRequest, Scope scope, SystemIndexAccess systemIndexAccess, Meta indexMetadata) {
            this.indices = indicesRequest.indices() != null ? ImmutableList.ofArray((Object[])indicesRequest.indices()) : ImmutableList.empty();
            this.indicesArray = indicesRequest.indices();
            this.indicesOptions = indicesRequest.indicesOptions();
            this.allowsRemoteIndices = indicesRequest instanceof IndicesRequest.Replaceable ? ((IndicesRequest.Replaceable)indicesRequest).allowsRemoteIndices() : false;
            this.includeDataStreams = indicesRequest.includeDataStreams();
            this.role = role;
            this.expandWildcards = this.indicesOptions.expandWildcardsOpen() || this.indicesOptions.expandWildcardsHidden() || this.indicesOptions.expandWildcardsClosed();
            this.localIndices = this.indices.matching(i -> !i.contains(":"));
            this.remoteIndices = ImmutableSet.of((Collection)this.indices.matching(i -> i.contains(":")));
            boolean bl = this.isAll = this.expandWildcards && this.isAll((List<String>)this.localIndices, this.remoteIndices, indicesRequest);
            this.containsWildcards = this.expandWildcards ? this.isAll || ActionRequestIntrospector.containsWildcard(this.indices) : false;
            this.writeRequest = indicesRequest instanceof DocWriteRequest;
            this.createIndexRequest = indicesRequest instanceof IndexRequest || indicesRequest instanceof CreateIndexRequest;
            this.indexMetadata = indexMetadata;
            this.scope = scope;
            this.systemIndexAccess = systemIndexAccess;
            this.negationOnlyEffectiveForIndices = scope != Scope.DATA_STREAM && scope != Scope.ALIAS;
        }

        IndicesRequestInfo(Action.AdditionalDimension role, String index, IndicesOptions indicesOptions, Scope scope, SystemIndexAccess systemIndexAccess, Meta indexMetadata) {
            this.indices = ImmutableList.of((Object)index);
            this.indicesArray = new String[]{index};
            this.indicesOptions = indicesOptions;
            this.allowsRemoteIndices = true;
            this.includeDataStreams = true;
            this.role = role;
            this.expandWildcards = indicesOptions.expandWildcardsOpen() || indicesOptions.expandWildcardsHidden() || indicesOptions.expandWildcardsClosed();
            this.localIndices = this.indices.matching(i -> !i.contains(":"));
            this.remoteIndices = ImmutableSet.of((Collection)this.indices.matching(i -> i.contains(":")));
            boolean bl = this.isAll = this.expandWildcards && this.isAll((List<String>)this.localIndices, this.remoteIndices, null);
            this.containsWildcards = this.expandWildcards ? this.isAll || ActionRequestIntrospector.containsWildcard(index) : false;
            this.writeRequest = false;
            this.createIndexRequest = false;
            this.indexMetadata = indexMetadata;
            this.scope = scope;
            this.systemIndexAccess = systemIndexAccess;
            this.negationOnlyEffectiveForIndices = scope != Scope.DATA_STREAM && scope != Scope.ALIAS;
        }

        IndicesRequestInfo(Action.AdditionalDimension role, List<String> indices, IndicesOptions indicesOptions, Scope scope, SystemIndexAccess systemIndexAccess, Meta indexMetadata) {
            this.indices = ImmutableList.of(indices);
            this.indicesArray = indices.toArray(new String[indices.size()]);
            this.indicesOptions = indicesOptions;
            this.allowsRemoteIndices = true;
            this.includeDataStreams = true;
            this.role = role;
            this.expandWildcards = indicesOptions.expandWildcardsOpen() || indicesOptions.expandWildcardsHidden() || indicesOptions.expandWildcardsClosed();
            this.localIndices = this.indices.matching(i -> !i.contains(":"));
            this.remoteIndices = ImmutableSet.of((Collection)this.indices.matching(i -> i.contains(":")));
            boolean bl = this.isAll = this.expandWildcards && this.isAll((List<String>)this.localIndices, this.remoteIndices, null);
            this.containsWildcards = this.expandWildcards ? this.isAll || ActionRequestIntrospector.containsWildcard(this.indices) : false;
            this.writeRequest = false;
            this.createIndexRequest = false;
            this.indexMetadata = indexMetadata;
            this.scope = scope;
            this.systemIndexAccess = systemIndexAccess;
            this.negationOnlyEffectiveForIndices = scope != Scope.DATA_STREAM && scope != Scope.ALIAS;
        }

        IndicesRequestInfo(List<String> indices, IndicesOptions indicesOptions, Scope scope, SystemIndexAccess systemIndexAccess, Meta indexMetadata) {
            this(null, indices, indicesOptions, scope, systemIndexAccess, indexMetadata);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.allowsRemoteIndices ? 1231 : 1237);
            result = 31 * result + (this.includeDataStreams ? 1231 : 1237);
            result = 31 * result + (this.writeRequest ? 1231 : 1237);
            result = 31 * result + (this.createIndexRequest ? 1231 : 1237);
            result = 31 * result + (this.indices == null ? 0 : this.indices.hashCode());
            result = 31 * result + (this.indicesOptions == null ? 0 : this.indicesOptions.hashCode());
            result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IndicesRequestInfo)) {
                return false;
            }
            IndicesRequestInfo other = (IndicesRequestInfo)obj;
            if (this.allowsRemoteIndices != other.allowsRemoteIndices) {
                return false;
            }
            if (this.includeDataStreams != other.includeDataStreams) {
                return false;
            }
            if (this.writeRequest != other.writeRequest) {
                return false;
            }
            if (this.createIndexRequest != other.createIndexRequest) {
                return false;
            }
            if (this.indices == null ? other.indices != null : !this.indices.equals(other.indices)) {
                return false;
            }
            if (this.indicesOptions == null ? other.indicesOptions != null : !this.indicesOptions.equals((Object)other.indicesOptions)) {
                return false;
            }
            if (this.role == null ? other.role != null : !this.role.equals(other.role)) {
                return false;
            }
            return this.scope.equals((Object)other.scope);
        }

        public boolean isExpandWildcards() {
            return this.expandWildcards;
        }

        public boolean containsWildcards() {
            return this.containsWildcards;
        }

        public boolean isAll() {
            return this.isAll;
        }

        private boolean isAll(List<String> localIndices, ImmutableSet<String> remoteIndices, IndicesRequest indicesRequest) {
            ImmutableSet aliases;
            AliasesRequest aliasesRequest;
            if (localIndices.isEmpty() && !remoteIndices.isEmpty()) {
                return false;
            }
            if (indicesRequest instanceof AliasesRequest && (aliasesRequest = (AliasesRequest)indicesRequest).aliases() != null && aliasesRequest.aliases().length != 0 && !(aliases = ImmutableSet.ofArray((Object[])aliasesRequest.aliases())).contains((Object)"*") && !aliases.contains((Object)"_all")) {
                return false;
            }
            return IndexNameExpressionResolver.isAllIndices(localIndices) || localIndices.size() == 1 && (localIndices.get(0) == null || localIndices.get(0).equals("*"));
        }

        ResolvedIndices resolveIndices() {
            if (this.isAll()) {
                return new ResolvedIndices(true, ResolvedIndices.Local.EMPTY, this.remoteIndices, (ImmutableSet<IndicesRequestInfo>)ImmutableSet.of((Object)this));
            }
            if (this.localIndices.isEmpty()) {
                return new ResolvedIndices(false, ResolvedIndices.Local.EMPTY, this.remoteIndices, (ImmutableSet<IndicesRequestInfo>)ImmutableSet.empty());
            }
            if (this.isExpandWildcards() && this.localIndices.size() == 1 && (this.localIndices.contains((Object)"_all") || this.localIndices.contains((Object)"*"))) {
                return new ResolvedIndices(true, ResolvedIndices.Local.EMPTY, this.remoteIndices, (ImmutableSet<IndicesRequestInfo>)ImmutableSet.of((Object)this));
            }
            return new ResolvedIndices(false, ResolvedIndices.Local.resolve(this, this.indexMetadata), this.remoteIndices, (ImmutableSet<IndicesRequestInfo>)ImmutableSet.empty());
        }

        public String toString() {
            return "[indices=" + this.indices + ", indicesOptions=" + this.indicesOptions + ", allowsRemoteIndices=" + this.allowsRemoteIndices + ", includeDataStreams=" + this.includeDataStreams + ", role=" + this.role + "]";
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        boolean isNegationOnlyEffectiveForIndices() {
            return this.negationOnlyEffectiveForIndices;
        }

        public IndicesRequest.Replaceable asIndicesRequestWithoutRemoteIndices() {
            return new IndicesRequest.Replaceable(){

                public String[] indices() {
                    if (remoteIndices.isEmpty()) {
                        return indicesArray;
                    }
                    return (String[])localIndices.toArray((Object[])new String[localIndices.size()]);
                }

                public IndicesOptions indicesOptions() {
                    return indicesOptions;
                }

                public boolean includeDataStreams() {
                    return includeDataStreams;
                }

                public IndicesRequest indices(String ... indices) {
                    return this;
                }

                public boolean allowsRemoteIndices() {
                    return allowsRemoteIndices;
                }
            };
        }

        public static enum Scope {
            ANY(true, true, true),
            INDEX(true, false, false),
            ALIAS(false, true, false),
            DATA_STREAM(false, false, true),
            INDICES_DATA_STREAMS(true, false, true),
            ANY_DISTINCT(true, true, true);

            final boolean includeIndices;
            final boolean includeAliases;
            final boolean includeDataStreams;

            private Scope(boolean includeIndices, boolean includeAliases, boolean includeDataStreams) {
                this.includeIndices = includeIndices;
                this.includeAliases = includeAliases;
                this.includeDataStreams = includeDataStreams;
            }

            public boolean includeIndices() {
                return this.includeIndices;
            }

            public boolean includeAliases() {
                return this.includeAliases;
            }

            public boolean includeDataStreams() {
                return this.includeDataStreams;
            }
        }
    }
}

